export type QuestionType = 'text' | 'dropdown' | 'yes_no' | 'number' | 'date' | 'photo' | 'voice';

export type ConsultationStatus = 'draft' | 'active' | 'inactive';

export interface ConsultationQuestion {
  id?: string;
  form_id: string;
  label: string;
  type: QuestionType;
  options?: string[]; // For dropdown questions
  required: boolean;
  order_index: number;
  created_at?: string;
  updated_at?: string;
}

export interface ConsultationForm {
  id?: string;
  vendor_id: string;
  title: string;
  description?: string;
  is_paid: boolean;
  price?: number;
  currency?: string;
  status: ConsultationStatus;
  created_at?: string;
  updated_at?: string;
  questions?: ConsultationQuestion[];
}

export interface ConsultationResponse {
  id?: string;
  form_id: string;
  customer_id?: string;
  invoice_id?: string;
  order_id?: string;
  responses: FormResponse[];
  submitted_at?: string;
  created_at?: string;
}

export interface FormResponse {
  question_id: string;
  answer: string | number | boolean;
  file_url?: string; // For photo/voice uploads
}

export interface CreateFormRequest {
  title: string;
  description?: string;
  is_paid: boolean;
  price?: number;
  currency?: string;
  fields: CreateQuestionRequest[];
}

export interface CreateQuestionRequest {
  label: string;
  type: QuestionType;
  options?: string[];
  required: boolean;
  order_index: number;
}

export interface SubmitResponseRequest {
  customer_id?: string;
  invoice_id?: string;
  order_id?: string;
  responses: FormResponse[];
}

export interface FormWithQuestions extends ConsultationForm {
  questions: ConsultationQuestion[];
}

export interface ResponseWithCustomer extends ConsultationResponse {
  customer?: {
    id: string;
    name: string;
    email?: string;
  };
}

export interface ConsultationAnalytics {
  total_responses: number;
  average_completion_time: number;
  most_common_answers: Record<string, any>;
  popular_questions: string[];
}

export interface ApiResponse<T = any> {
  success: boolean;
  data?: T;
  error?: string;
} 